function quantifyCallback(hObject, callbackdata, I, BW2, scale, factor, filename)
global aponeurosis;

mask=aponeurosis;

[x,y] = ginput(3);
x=round(x);
y=round(y);

%1st to 2nd point distance
D1 = bwdistgeodesic(mask, x(1),y(1), 'quasi-euclidean');
D2 = bwdistgeodesic(mask, x(2),y(2), 'quasi-euclidean');
D = D1 + D2;
D = round(D * 8) / 8;

D(isnan(D)) = inf;
paths = imregionalmin(D);

paths_thinned_many = bwmorph(paths, 'thin', inf);
[B,L] = bwboundaries(paths_thinned_many,'noholes');
hold on
boundary = B{1};
plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 2)
distance1=D1(y(2),x(2));

%2nd to 3rd point distance
%1st to 2nd point distance
D1 = bwdistgeodesic(mask, x(2),y(2), 'quasi-euclidean');
D2 = bwdistgeodesic(mask, x(3),y(3), 'quasi-euclidean');
D = D1 + D2;
D = round(D * 8) / 8;

D(isnan(D)) = inf;
paths = imregionalmin(D);

paths_thinned_many = bwmorph(paths, 'thin', inf);
[B,L] = bwboundaries(paths_thinned_many,'noholes');
hold on
boundary = B{1};
hold on, plot(boundary(:,2), boundary(:,1), 'r', 'LineWidth', 2)
distance2=D2(y(2),x(2));

alength=(distance1 + distance2)*scale/factor;
aarea=scale*scale*length(find(mask==1))/factor/factor;
avolume=5*scale*scale*length(find(mask==1))/factor/factor;
fprintf('aponeurosis length is %f (mm), %f (pixels)\n', alength, (distance1 + distance2));
fprintf('aponeurosis area is %f (mm^2), %d (pixels)\n', aarea, length(find(mask==1)));
fprintf('aponeurosis slide volume is %f (mm^3), %d (voxels)\n', avolume, length(find(mask==1)));

outputfilename='output.csv';
if exist(outputfilename, 'file') ~= 2
    fid=fopen(outputfilename, 'a+');
    fprintf(fid, 'Filename; length; area; volume\n');
else
    fid=fopen(outputfilename, 'a+');
end
fprintf(fid, '%s; %f; %f; %f\n', filename,alength,aarea,avolume);
fclose(fid);

end