[filename,user_canceled] = imgetfile;
%only for png files
%I=rgb2gray(imread(filename));
info=dicominfo(filename);
pixelSpacing=info.PixelSpacing;
scale=pixelSpacing(1);
I=dicomread(filename);
imin=min(min(I));
imax=max(max(I));
I=uint8(255.0*double(I-imin)/double(imax-imin));
factor=6;
I=imresize(I, factor*size(I));
f=figure;
imshow(I, 'InitialMagnification', 250);
axis off; % Turn off axis numbering

%ask for aponeurosis
BW1=roipoly;
[L,n]=bwlabel(BW1);
RGB=label2rgb(L, 'autumn', 'black', 'shuffle');
imshow(I, 'InitialMagnification', 250);
hold on;
himage = imshow(RGB);
himage.AlphaData = 0.3;
drawnow;

%ask for muscle
BW2=roipoly;
mask=BW1;
mask(BW2)=2;
[L,n]=bwlabel(mask);
RGB=label2rgb(L, 'autumn', 'black', 'shuffle');
imshow(I, 'InitialMagnification', 250);
hold on;
himage = imshow(RGB);
himage.AlphaData = 0.3;
drawnow;

%apoCoordinates=[840 538; 866 532; 898 512; 902 496; 896 472; 874 496; 840 538];
%musCoordinates=[632 544; 676 546; 750 478; 760 396; 612 426; 632 544];
%BW1 = poly2mask(apoCoordinates(:,1), apoCoordinates(:,2), size(I,1), size(I,2));
meanApo=mean(I(BW1));

%BW2 = poly2mask(musCoordinates(:,1), musCoordinates(:,2), size(I,1), size(I,2));
meanMus=mean(I(BW2));

%%%%%%%%%%%%%%%%%%%%%
thresholdPct=51; %pct
%%%%%%%%%%%%%%%%%%%%%
threshold=meanApo+double(meanMus-meanApo)*thresholdPct/100.0;
aponeurosisTh=I<threshold;
global aponeurosis
aponeurosis=BW1 | aponeurosisTh ;
[L,n]=bwlabel(aponeurosis);
indx=find(BW1==1);
aponeurosis= L==L(indx(1));
aponeurosis(BW2)=2;

[L,n]=bwlabel(aponeurosis);
RGB=label2rgb(L, 'autumn', 'black', 'shuffle');

% Initial Image
hold on;
himage = imshow(RGB);
himage.AlphaData = 0.3;

%SLIDER
b = uicontrol('Parent',f,'Style','slider','Position',[81,54,419,23],...
              'value',thresholdPct, 'min',0, 'max',100);
bgcolor = f.Color;
bl1 = uicontrol('Parent',f,'Style','text','Position',[50,54,23,23],...
                'String','0','BackgroundColor',bgcolor);
bl2 = uicontrol('Parent',f,'Style','text','Position',[500,54,23,23],...
                'String','100','BackgroundColor',bgcolor);
bl3 = uicontrol('Parent',f,'Style','text','Position',[240,25,100,23],...
                'String',sprintf('Threshold %2.2f', thresholdPct),'BackgroundColor',bgcolor);
            
b.Callback = @(hObject, event) sliderCallback(hObject, event, meanMus, meanApo, I, BW1, bl3, BW2) ;

%QUANTIFY
btn = uicontrol('Style', 'pushbutton', 'String', 'Quantify',...
        'Position', [20 600 50 20],...
        'Callback', @(hObject, event) quantifyCallback(hObject, event, I, BW2, scale, factor, filename)  ); 

