%METHOD1: per image black pixels elimination
function [datosPascalesRaw, datosPascales, porcentajePuntos]=...
    perFrameCleaning(video, nframes, startFrame, cropRect, threshold, escalaPascales)

datosPascalesRaw=zeros(nframes+1,1);
datosPascales=zeros(nframes+1,1);
porcentajePuntos=zeros(nframes+1,1);

k=1;
for i=startFrame:nframes
    I1=read(video,i);
    
    I=I1(cropRect(2):cropRect(2)+cropRect(4),cropRect(1):cropRect(1)+cropRect(3),:);
    Ir=I(:,:,1);
    Ig=I(:,:,2);
    Ib=I(:,:,3);
    
    hsv_image = rgb2hsv(I);
    zonaColor = hsv_image(:,:,2).*hsv_image(:,:,3);
    level = graythresh(zonaColor);
    BW = im2bw(zonaColor,threshold*level);
    
    r=Ir(true(size(BW)));
    g=Ig(true(size(BW)));
    b=Ib(true(size(BW)));
    
    %from RGB to kPa
    datos=uint8(reshape([r g b],  [1 length(r) 3]));
    pascales=escalaPascales * double(dither(datos, jet(256)))/255;
    
    datosPascalesRaw(k)=mean(pascales);
    
    r=Ir(BW);
    g=Ig(BW);
    b=Ib(BW);
    
    %from RGB to kPa
    datos=uint8(reshape([r g b],  [1 length(r) 3]));
    pascales=escalaPascales * double(dither(datos, jet(256)))/255;
    
    datosPascales(k)=mean(pascales);
    
    porcentajePuntos(k)=sum(sum(BW))/(size(BW,1)*size(BW,2));
    k=k+1;
    if mod(k,30) == 0
        fprintf('.');
    end
end
fprintf('\n');

end