%METHOD2: per sequence black pixels elimination
function [datosPascales, porcentajePuntos]=...
    perSequenceCleaning(video, nframes, startFrame, cropRect, threshold, escalaPascales)

datosPascales=zeros(nframes+1,1);
Itest=read(video,1);
check = true([size(Itest,1) size(Itest,2)]);
check = check(cropRect(2):cropRect(2)+cropRect(4),cropRect(1):cropRect(1)+cropRect(3),:);
%common non-black area
fprintf('\tPreprocessing...\n');
k=1;
for i=startFrame:nframes
    I1=read(video,i);
    
    I=I1(cropRect(2):cropRect(2)+cropRect(4),cropRect(1):cropRect(1)+cropRect(3),:);
    
    hsv_image = rgb2hsv(I);
    zonaColor = hsv_image(:,:,2).*hsv_image(:,:,3);
    level = graythresh(zonaColor);
    BW = im2bw(zonaColor,threshold*level);
    check = check & BW;
    if mod(k,30) == 0
        fprintf('.');
    end
    k=k+1;
end
fprintf('\n');

porcentajePuntos=sum(sum(check))/(size(check,1)*size(check,2));

fprintf('\tRunning...\n');
k=1;
for i=startFrame:nframes
    I1=read(video,i);
    I=I1(cropRect(2):cropRect(2)+cropRect(4),cropRect(1):cropRect(1)+cropRect(3),:);
    
    Ir=I(:,:,1);
    Ig=I(:,:,2);
    Ib=I(:,:,3);
    
    r=Ir(check);
    g=Ig(check);
    b=Ib(check);
    
    %conversion desde RGB a pascales
    datos=uint8(reshape([r g b],  [1 length(r) 3]));
    pascales=escalaPascales * double(dither(datos, jet(256)))/255;
    
    datosPascales(i-startFrame+1)=mean(pascales);
    if mod(k,30) == 0
        fprintf('.');
    end
    k=k+1;
end
fprintf('\n');

end