%read input excel parameters file
inputTable=readtable('inputVideos.xlsx');

for i=1:size(inputTable,1)
    %read parameters from excel file
    filename=inputTable{i,1}{1,1};
    escalaPascales=str2num(inputTable{i,2}{1,1});
    startFrame=inputTable{i,3};
    samplingHz=str2num(inputTable{i,4}{1,1});
    cropRect=str2num(inputTable{i,5}{1,1});
    
    fprintf('Processing: %s\n', filename);
    %estimate values from videos
    [datosPascalesRaw1, datosPascales1, porcentajePuntos1, ...
           datosPascales2, porcentajePuntos2, framerate]=...
           COMP_METHOD_ELASTOGRAPHY(filename, escalaPascales, startFrame, cropRect);
    
    jump=floor(framerate*1.0/samplingHz);
    %save results
    saveTable(datosPascalesRaw1, datosPascales1, porcentajePuntos1, ...
             datosPascales2, porcentajePuntos2, filename, jump);
end